<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPortfolio extends CPlugin{
	
	var $tplvars; 

	function CPortfolio() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "portfolio";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "item":
					return $this->Item();
				break;
				
			}
		}
		
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"onepage"					=> "onepage.htm",

			"item"						=> "item.htm",
			"image"						=> "image.htm",

			"widget.categories"			=> "widget.categories.htm",
			"widget.projects"			=> "widget.projects.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		//read all categories
		$cats = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1  
			ORDER BY  
				cat_order ASC 
			"
		);


		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l,

				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND

				i.item_cat=c.cat_id AND 
				i.item_id=il.item_id AND 
				il.lang_id={$this->tpl_module[lang_id]} AND 
				i.module_id={$this->tpl_module[mod_id]} AND
				item_status = 1


			ORDER BY  
				item_order ASC
			"
		);

		if (is_array($items)) {

			$cats_count = count($cats);

			$items = $this->ProcessItems($items);
			foreach ($items as $key => $val) {
				//$items[$key] = $this->ProcessImage($val);

				if ($cats_count  < 2) {
					$items[$key]["cat_title"] = "";
				}
				
			}			
		}		

		$text = $this->GetTexts();

		$this->module->plugins["modules"]->SetSeo(
			$text
		);

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);

		$template = &$this->private->templates["onepage"];

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"cats"	=> count($cats) > 1 ? $base->html->Table(
						$template, 
						"Cats" , 
						$cats
					) : "",

					"items"	=> $base->html->Table(
						$template, 
						"Photos" , 
						$items
					),

				),
				$text,	
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
					


	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items) {
		global $base;

		if (is_array($items)) {
			foreach ($items as $key => $val) {				
				$items[$key]["link"] = $val["link"] = $this->tpl_module["link"] . "{$val[item_url]}/";			
			}			
		}
		

		return $items;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ItemImage($item , $type) {
		global $_LANG_ID;

		$template = &$this->private->templates["image"];

		switch ($type) {
			case "list":

				if (!$item["item_image"]) {
					return "";
				}

				if ($item["item_image"] == "1") {

					$items = $this->db->QFetchROwArray(
						"
						SELECT * FROM 
							{$this->tables['plugin:portfolio_images']} as r,
							{$this->tables['plugin:portfolio_images_lang']} as l
						WHERE
							r.item_id = l.item_id AND 
							r.item_parent = {$item['item_id']} AND 
							l.lang_id = {$_LANG_ID}

						ORDER BY 
							item_order ASC
						LIMIT 
							1
						"
					);
				} else {
					$items = $this->db->QFetchROwArray(
						"
						SELECT * FROM 
							{$this->tables['plugin:portfolio_images']} as r,
							{$this->tables['plugin:portfolio_images_lang']} as l
						WHERE
							r.item_id = l.item_id AND 
							r.item_parent = {$item['item_id']} AND
							l.lang_id = {$_LANG_ID}

						ORDER BY 
							item_order ASC
						"
					);
				}								
			break;

			case "details":
				$items = $this->db->QFetchROwArray(
					"
					SELECT * FROM 
						{$this->tables['plugin:portfolio_images']} as r,
						{$this->tables['plugin:portfolio_images_lang']} as l
					WHERE
						r.item_id = l.item_id AND 
						r.item_parent = {$item['item_id']} AND
						l.lang_id = {$_LANG_ID}

					ORDER BY 
						item_order ASC
					"
				);
			break;
		}
		


		if (!is_array($items)) {
			return "";
		}

		if (count($items) == 1) {
			//simple image / video / youtube

			switch ($items[0]["item_type"]) {

				//image
				case "1":
					$return  = $template->BlockReplace(
						"Image" , 
						$items[0],
						array(
							"title"	=> $items[0]["item_title"] ? $template->blockReplace("Title" , $items[0]) : ""
						)
					);
				break;

				//youtube
				case "2":
					$return  = $template->BlockReplace(
						"Youtube" , 
						$items[0]
					);
				break;

				//vimeo
				case "3":
					$return  = $template->BlockReplace(
						"Vimeo" , 
						$items[0]
					);
				break;
			}
			
		} else {

			//image slider 
			global $base;

			foreach ($items as $key => $val) {

				switch ($val["item_type"]) {
					case "1": $items[$key]["content"] = $template->blockReplace("SliderImage" , $val); break;
					case "2": $items[$key]["content"] = $template->blockReplace("SliderYoutube" , $val); break;
					case "3": $items[$key]["content"] = $template->blockReplace("SliderVimeo" , $val); break;
				}
				
			}

			$return  = CTemplateStatic::Replace(
				$base->html->Table(
					$template , 
					"Slider" , 
					$items
				),
				array(
					"count"	=> count($items),
				)
			);
		}


		if ($return) {

			return  CTemplateStatic::Replace(
				$return,
				array(
					"link"	=> $item["link"],
				)
			);

		}						
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Item() {
		global $base;

		$item = $this->db->QFetchArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_items']} as c,
				{$this->tables['plugin:portfolio_items_lang']} as l
			WHERE 				

				c.item_id=l.item_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND  
				l.item_url LIKE \"%s\" AND
				c.item_status=1
			",
			array(
				$_GET["item_code"]
			)
		);

		if (!is_array($item)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$item["link"] = $this->tpl_module["link"] . "{$item[item_url]}/";

		$text = $this->GetTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$item["link"]	=> $item["item_title"],
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);



		$this->module->plugins["seo"]->PageMeta(
			$item
		);

		$template = &$this->private->templates["item"];


		$item["img"] = $this->ItemImage($item, "details");

		if ($item["item_specs"]) {
			$tmp = explode("\n" , $item["item_specs"]);
			$_tmp = array();

			foreach ($tmp as $k => $v) {

				$tmp2 = explode("|" , trim($v));

				$_tmp[] = array(
					"title"	=> $tmp2[0],
					"value"	=> $tmp2[1],
				);
			}


			foreach ($_tmp as $key => $val) {
				if (trim($val["value"])){
					$_tmp[$key]["title"] = $template->blockReplace("HeadlineTitle" , $val);
				}
			}


			$item["headline"] = $base->html->table(
				$template,
				"Headline" , 
				$_tmp
			);

		} else {
			$item["headline"] = "";
		}


		if ($item["item_online"]) {
			$item["online_butt"] = $template->blockReplace("OnlineButt" , $item);
		} else {
			$item["online_butt"] = "";
		}


		if ($this->tpl_module["settings"]["set_categories"]) {
			$item["back_link"] = $this->tpl_module["link"];
		} else {
			$item["back_link"] = $this->tpl_module["link"] . $item["cat_url"] . "/";
		}


		if ($this->plugins["comments"]) {
			$item["comments"] = $this->module->plugins["comments"]->Comments(
				$item["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$item["comments"] = "";
		}

		$item["back_link"] = $this->tpl_module["link"];

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockReplace(
				$item["headline"] ? "Main" : "MainNoDetails", 
				$item,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
	}




	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "2":
				return $this->widgetLatestProjects($widget);
			break;

		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetLatestProjects($widget) {
		global $base;


		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l,
				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$widget[lang_id]} AND 
				c.module_id={$widget[widget_module]} AND 
				c.cat_status = 1 AND

				i.item_cat=c.cat_id AND 
				i.item_id=il.item_id AND 
				il.lang_id={$widget[lang_id]} AND 
				i.module_id={$widget[widget_module]} AND 
				item_status = 1

			ORDER BY  
				item_date DESC

			LIMIT " . max($widget[settings][set_items] , 4)
		);

		if (is_array($items)) {

			//$items = $this->ProcessItems($items);
			foreach ($items as $key => $val) {
				$items[$key]["link"] = $widget["link"] . $val["item_url"] . "/";
			}
			
			$template = &$this->private->templates["widget.projects"];

			return $template->blockReplace(
				"Main",
				array(
					"items"	=> $base->html->Table(
						$template , 
						"" , 
						$items
					)
				),
				$widget,
				$widget["settings"]
			);
		}		


	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAllLinks($module , &$links) {
		
		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT item_url " . 
			"FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l,

				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				c.cat_status = 1 AND

				i.item_cat=c.cat_id AND 
				i.item_id=il.item_id AND 
				il.lang_id={$module[lang_id]} AND 
				i.module_id={$module[mod_id]} AND
				item_status = 1


			ORDER BY  
				item_date DESC
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"url"	=> $module["link"] . "{$val[item_url]}/"			
				);
			}			
		}
		
	}


}

?>