<?php
/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPlugin{
	
	var $tplvars; 

	function CPlugin() {		
	}

	function __load() {

		//load the config file
		$this->_xmlFile = _MODPATH . $this->name . "/module.xml";
		$this->_xmlPath = _MODPATH . $this->name;


		if (file_exists($this->_xmlFile)) {
			$conf = new CConfig($this->_xmlFile);
			$this->conf = $conf->vars["module"];


			//load the templates and the tables
			if (is_array($this->conf["tables"])) {
				foreach ($this->conf["tables"] as $key => $val) {
					$this->private->tables[$key] = $val;
				}
			}
		}


		global $site;

		if (!$site->admin) {

			$rules = $this->_xmlPath . "/rewrite.txt";
			if (file_exists($rules)) {
				$rules_list = file($rules);

				if (is_array($rules_list) && count($rules_list)) {
					foreach ($rules_list as $key => $val) {

						$site->rewriteRules[] = str_replace("\t" , " " , trim($val));
					}
					
				}
				
			}
			
		}
		

/*
			//load the templates
			if (is_array($this->conf["templates"])) {
				foreach ($this->conf["tables"] as $key => $val) {
					$this->private->templates[$key] = new CTemplateDyn($val);
				}
				
			}
			
		}
*/					
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __preinit() {

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents() {
		global $_CONF;
		
//		$_CONF["forms"]["adminpath"] = "../"
		

	}

	function __adminMenu() {
		global $_SESS , $_TSM , $_USER;

		if (!$this->admin) {
			return "";
		}


		//everithing is okay, proceed to themenu building

		if (file_exists( $this->path . "menu.xml") && !(defined("STP_DISABLE_MODULE_" . strtoupper($this->name) ) && constant("STP_DISABLE_MODULE_" . strtoupper($this->name)) )) {


			//check the permission agains this module

			if (is_object($this->plugins["administrators"]) && $this->plugins["administrators"]->CheckGlobalPermission($this->name)) {

				$tmp_menu = new CConfig($this->path . "menu.xml");

				if (is_array($tmp_menu->vars["menu"])){
					foreach ($tmp_menu->vars["menu"] as $key => $val) {

						if (is_array($val["link"])) {
							$links = array();

							foreach ($val["link"] as $k => $v) {

								$links[] = $v;
							}


						} else {

							$links = $val["link"];
						}

						$k = $val["id"] ? $val["id"] : ucwords($key);

						if ($val["restricted"] && CForm::__isRestricted($val["restricted"])) {
						} else {				
							$this->private->menu[$k] = array(
								"id"	=> $val["id"] ? $val["id"] : "",
								"icon"	=> $val["icon"],
								"prio"	=> $val["prio"] ? $val["prio"] : "999",
								"title"	=> ucwords($key),
								"link"	=> $links , 
								"pos"	=> $val["pos"],
								"level"	=> $val["level"],
								"parent"=> $val["parent"],
								"subtitle"=> $val["subtitle"],
							);
						}
						

						
					}

				}
			}
			

			
						
		}

	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareFields(&$forms) {

		global $_TSM;

		if ($this->tpl_module["mod_name"]) {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["mod_name"];
		} else {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["module_name"] ? $this->tpl_module["module_name"] : $this->tpl_module["module_type_name"];
		}
		


		if (is_array($forms["list"])) {
			$forms["list"]["title"] = CTemplateStatic::Replace(
				$forms["list"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		

		if (is_array($forms["edit"])) {
			$forms["edit"]["title"] = CTemplateStatic::Replace(
				$forms["edit"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		

		if (is_Array($forms["add"])) {
			$forms["add"]["title"] = CTemplateStatic::Replace(
				$forms["add"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		
		if (is_Array($forms["details"])) {
			$forms["details"]["title"] = CTemplateStatic::Replace(
				$forms["details"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}

		if (is_Array($forms["search"])) {
			$forms["search"]["title"] = CTemplateStatic::Replace(
				$forms["search"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}

		//prepare the tabs

		if (file_exists($this->forms_path . "dashboard.xml")) {
			$tabs = new CConfig($this->forms_path . "dashboard.xml" );

			if ($tabs->vars["tabs"]["link"]) {
				$tabs = new CConfig($this->forms_path . $tabs->vars["tabs"]["link"]);
			}

			$this->global_tabs = $tabs->vars["tabs"];
		}
		

		if (is_Array($forms["search"])) {	
			$forms["search"]["tabs"] = $this->global_tabs;
		} else {
			$forms["list"]["tabs"] = $this->global_tabs;
		}

		if (is_Array($forms["edit"])) {	
			$forms["edit"]["tabs"] = $this->global_tabs;

//			$this->LangPrepareFields(&$forms["edit"]);
		}

		if (is_Array($forms["add"]) && !is_Array($forms["add"]["tabs"])) {	
			$forms["add"]["tabs"] = $this->global_tabs;
		}
		
		if (is_Array($forms["details"])) {	
			$forms["details"]["tabs"] = $this->global_tabs;
//			$this->LangPrepareFields(&$forms["details"]);

		}

		if (is_Array($forms["add"])) {	
//			$this->LangPrepareFields(&$forms["add"]);

		}

		
		if ($this->name !="languages") {
			if (!$_REQUEST["lang_id"]) {
				$lang = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1");
				$_GET["lang_id"] = $lang["lang_id"];
			}
		}
		


	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareDashboard(&$form) {
		global $_TSM;

		if ($this->tpl_module["mod_name"]) {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["mod_name"];
		} else {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["module_name"] ? $this->tpl_module["module_name"] : $this->tpl_module["module_type_name"];
		}

		if (file_exists($this->forms_path . "dashboard.xml")) {			

			$tabs = new CConfig($this->forms_path . "dashboard.xml");

			if ($tabs->vars["tabs"]["link"]) {
				$tabs = new CConfig($this->forms_path . $tabs->vars["tabs"]["link"]);
			}

			$this->global_tabs = $tabs->vars["tabs"];

			$form["tabs"] = $this->global_tabs;

		}

		//check for multilanguage
	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardWidgets() {
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminGetWidgets($module) {
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Widget($widget) {
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function UserMenuAppend($module){
		global $_SESS;

		if ($module["deny"]) {
			return "";
		}
		

		if ($module["mod_protected"] && is_array($_SESS["client"])) {

			if ($module["module_code"] != "category") {

				switch ($module["module_type"]) {
					case "1":
						return array(
							array(
								"title"	=> $module["mod_name"], 
								"link"	=> $module["link"],
								"priority"	=> 10,
								"current"	=> $module["mod_id"] == $_GET["module_id"] ? "true" : "",
							),

						);
					break;

					case "2":
						return array(
							array(
								"title"	=> $module["module_name"], 
								"link"	=> $module["link"],
								"priority"	=> 10,
								"current"	=> $this->name == $_GET["mod"] ? "true" : "",

							),

						);
					break;
				}
			}			
		}
	}

	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __install($module) {
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __uninstall($module) {
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __adminTexts($sub = "texts") {

			if (!$_GET["action"]) {
				$_GET["action"] = "details";
			}


			if (!$this->tpl_module["mod_id"] && $this->tpl_module["module_id"]) {
				$_GET["module_id"] = $this->tpl_module["module_id"];
			}
			

			//check id
			
			$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);

			$this->PrepareFields($data->forms["forms"]);

			$this->__adminTextsCheckTextRecord($data->forms);

			$data->functions = array( 
//					"onstore_prepare" => array(&$this , "__StoreAdminTexts"),
			);					

			return $data->DoEvents();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getTexts($tables = array() , $sub_id = "") {

		if (!count($tables)) {
			$tables = array(
				"core"	=> $this->tables["core:texts"],
				"lang"	=> $this->tables["core:texts_lang"],
			);
		}
		



		if ($this->tpl_module["mod_id"]) {
			$text = $this->db->QFetchArray(
				"SELECT * FROM 
					{$tables['core']} as r , 
					{$tables['lang']} as l
				WHERE
					r.module_id = l.module_id AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND
					r.module_id={$this->tpl_module[mod_id]} 
				" . ($sub_id ? " AND r.sub_id LIKE '{$sub_id}' AND l.sub_id LIKE '{$sub_id}' " : "")
			);

			return $text;
		} else {
			$text = $this->db->QFetchArray(
				"SELECT * FROM 
					{$tables['core']} as r , 
					{$tables['lang']} as l
				WHERE
					r.module_id = l.module_id AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND
					r.module_id={$this->tpl_module[module_id]}
				" . ($sub_id ? " AND l.sub_id LIKE '{$sub_id}' " : "")
			);

			return $text;
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __StoreAdminTexts($record) {


	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __adminTextsCheckTextRecord(&$forms) {

		if (!$_GET["module_id"]) {
			return "";
		}
		

		if (!is_array($this->db->QFetchArray("SELECT * FROM " . $this->tables[$forms["table"]] . " WHERE module_id={$_GET[module_id]}" . ($_GET["sub_id"] ? " AND sub_id LIKE '{$_GET[sub_id]}' " : "" ))  )) {
			$this->db->QueryInsert(
				$this->tables[$forms["table"]],
				array(
					"module_id"	=> $_GET["module_id"],
					"sub_id"	=> $_GET["sub_id"],
				)
			);
		}		

	}

	
	function LangPrepareFields(&$form) {
		global $base;

	
		if (!$_REQUEST["lang_id"]) {
			$lang = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1");
			$_GET["lang_id"] = $lang["lang_id"];
		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMenuButton($record) { 
		global $_SESS , $_CONF;

		if (is_array($record)) {


			//to be fixed
			if (
					$record["mod_invisible"] || 
					($record["mod_protected"] && !is_array($_SESS["client"])) 
			) {

			} else {			

				switch ($record["module_type"]) {
					//instance
					case "1":
						return array(
							"mod_id"	=> $record["mod_id"],
							"title"		=> $record["mod_name"],
							"link"		=> $record["home"] ? ($record["home_link"] ? $record["home_link"] : $_CONF["url"])  : $record["link"],
							"subtitle"	=> $record["mod_subtitle"],
							"selected"	=> $record["mod_id"] == $_GET["module_id"]  ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					break;

					//system
					case "2":
						return array(
							"mod_id"	=> "m-" . $record["module_id"],
							"title"		=> $record["module_name"],
							"link"		=> $record["link"],
							"subtitle"	=> $record["module_subtitle"],
							"selected"	=> $record["module_id"] == $_GET["module_id"]  ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					break;
				}
								
			}
		}

		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		//load any existing settings
		if (file_exists($this->path . "install/settings.xml")) {
			$settings = new CConfig($this->path . "install/settings.xml");

			$this->plugins["modules"]->UpdateModuleSettings(
				$module_data["mod_id"] , 
				$settings->vars["settings"]
			);
		}


		//load createsql if exists
		if (file_exists($this->path . "install/create.sql")) {
			$db_file = file($this->path . "install/create.sql");

			if (count($db_file)) {
				foreach ($db_file as $key => $val) {

					$val = trim($val);

					if (substr($val, -1) == ";") {

						$last .= $val;

						$this->db->Query(
							CTemplateStatic::Replace(
								$last,
								$this->tables,
								$module_tata
							)
						);

						$last = "";

					} else {
						$last .= $val;
					}
				}
			}
		}

	}
	
	
}

?>