<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CLayouts extends CPlugin{
	
	var $tplvars; 

	function CLayouts() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "layouts") {
			switch ($_GET["sub"]) {
			}
			
		}

	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"generic"				=> "generic.htm",
			"generic.footer"		=> "generic.footer.htm",
			"parallax"				=> "parallax.htm",
			"background"			=> "background.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($lid , $content , $lw = "" , $header = "" , $footer = "") {

		if (!STP_DISABLE_MODULE_LAYOUTS) {
			//load the selected layout
			if ($lid) {
				$layout = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_id={$lid} ");			
			}				


			//if no layout then try to load the generic layout
			if (!is_array($layout)) {
				$layout = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_generic=1 LIMIT 1");			
			}		

		}

		//i have no generic layout so ... return a no column layout
		if (!is_array($layout)) {

			$this->__init();

			$template = &$this->private->templates["generic"];

			return $template->blockReplace(
				"NoCols" , 
				array(
					"data"		=>	$content,
					"header"	=> $header,
					"footer"	=> $footer,
				)

			);

		} else {
			


			//read the blocks
			$blocks = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_parent = {$layout[layout_id]} ORDER BY layout_order ASC");

			

			//read all the ids
			if (!is_array($blocks)) {
				return "";
			}

			foreach ($blocks as $key => $val) {
				$ids[] = $val["layout_id"];
			}				


			$this->__init();

			//read all the widgets

			//read all the columns
			$widgets = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:layouts_items']} WHERE layitem_layout IN (" . implode("," , $ids) . ") ORDER BY layitem_layout,layitem_column,layitem_order ASC");


			//process the content of the widget

			if (is_array($widgets)) {
				foreach ($widgets as $key => $val) {

					switch ($val["layitem_widget"]) {
						case "-1":
						case "-2":
						break; 

						default:
							$wid[] = $val["layitem_widget"];
						break;
					}
				}

				if (is_array($wid)) {
					$wid = implode("," , $wid);					
				}
				
				if ($lw) {

					if ($wid) {
						$wid .= "," . $lw;
					} else {
						$wid = $lw;
					}
					
				}

				//read the widget information
				$widgets_data =  $this->module->plugins["widgets"]->Widgets(
					$wid,
					"array"
				);


				
				foreach ($widgets as $key => $val) {
					switch ($val["layitem_widget"]) {
						//current module content
						case "-1":
							$data[$val["layitem_layout"]][$val["layitem_column"]] .= $content;
						break;

						case "-2":

						break;

						default:

							if (is_Array($widgets_data[$val["layitem_widget"]])) {
								$data[$val["layitem_layout"]][$val["layitem_column"]] .= $widgets_data[$val["layitem_widget"]]["content"];
							}
							
						break;

					}
					
				}
			}


			//build the html with columns


			foreach ($blocks as $kblock => $block) {

				$path = $this->tpl_path . $block["layout_template"] . ".block.htm";

				if (file_exists($path)) {
					$template = new CtemplateDynamic($path );
				} else {					

					//footer template
					if ($layout["layout_template"] == "2") {
						$template = &$this->private->templates["generic.footer"];
					} else {
						$template = &$this->private->templates["generic"];
					}
					
				}

				$cols = "";
				
				for ($i = 1; $i<=$block["layout_columns"] ; $i++) {

					$class = "";						

					if ($i== 1) {
						$class .= $template->Blockreplace("First" , array());
					}


					if ($i== $block["layout_columns"]) {
						$class .= $template->Blockreplace("Last" , array());
					}

					if ($block["layout_c" . $i . "_sm"]) {
						$class .= " col-sm-" . $block["layout_c" . $i . "_sm"];
					}

					if ($block["layout_c" . $i . "_xs"]) {
						$class .= " col-xs-" . $block["layout_c" . $i . "_xs"];
					}


					$cols .= $template->blockReplace(
						"Column",
						array(
							"size"		=> $block["layout_c" . $i],
							"content"	=> $data[$block["layout_id"]][$i],
							"class"		=> $class,
						)
					);
					
				}

				//process the background
				$block["layout_bg_fixed"] = $block["layout_bg_fixed"] ? "fixed" : "scroll";
				
				$background = $inverted = $block["layout_bg_inverted"] ? $this->private->templates["background"]->blockReplace("Inverted") : "";				

				switch ($block["layout_bg"]) {
					//custom image
					case "2":
						$background = $this->private->templates["background"]->blockReplace(
							"Image",
							$block
						);
						
						$inverted = $block["layout_bg_inverted"] ? $this->private->templates["background"]->blockReplace("Inverted") : "";
					break;

					//color
					case "3":
						//prepare the color 
						$color = $this->hex2rgb($block["layout_bg_color"]);

						$background = $this->private->templates["background"]->blockReplace(
							"Color",
							array(
								"r"	=> $color["r"],
								"g"	=> $color["g"],
								"b"	=> $color["b"],
								"a"	=> $block["layout_bg_alpha"],
							)
						);

						$inverted = $block["layout_bg_inverted"] ? $this->private->templates["background"]->blockReplace("Inverted") : "";
					break;

					//custom video
					case "4":
						$background = $this->private->templates["background"]->blockReplace(
							"Video",
							$block
						);
						
						$inverted = $block["layout_bg_inverted"] ? $this->private->templates["background"]->blockReplace("Inverted") : "";
					break;

				}
				
				
				if ($block["layout_bg_overlay"] && ( $block["layout_bg"] > 1) ) {
					$inverted .= " " . $this->plugins["skineditor"]->Overlay($block["layout_bg_overlay"]);
				}
				


				$final_html .= $this->Parallax(
					$template->blockReplace(
						"Main" , 
						array(
							"columns"		=> $cols,
							"header"		=> $header,
							"footer"		=> $footer,
							"background"	=> $background,
							"inverted"		=> $inverted,
							"layout_id"		=> $block["layout_id"]
						)
					),
					$block

				);

			}
			
			return $final_html;

		}		
	}
		

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {

		global $_SESS , $_TSM;

		//detect the footer layout from current module
		if ($module["settings"]["set_layout_footer"]) {
			//detect the default footer
			$layout = $module["settings"]["set_layout_footer"];
		}

		//generic layouts
		if (!$layout) {
			//detect module status
			if ($module["mod_protected"] || $module["module_protected"]) {
				$layout = $this->vars->data["set_layout_footer_protected"];				
			} else {			
				$layout = $this->vars->data["set_layout_footer"];
			}
		}

		//render footer layout
		if ($layout) {
			$_TSM["PUB:FOOTER"] = $this->Render($layout, "");
		} else {
			//clean footer variable
			$_TSM["PUB:FOOTER"] = "";
		}


	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function detect($default , $protected = false) {
		global $_SESS;

		//in future i should add some caching to save an extra check.
		if ($default) {

			//check if layout exists or was deleted
			$layout = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_id={$default} ");			

			if (is_array($layout)) {
				return $default;
			}
			
		}

		if ($protected ) {
			return $this->vars->data["set_layout_protected"];
		} else {
			return $this->vars->data["set_layout"];
		}
			
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Parallax($content , $block) {

		if (!$block["layout_parallax"]) {
			return $content;
		}

		$this->__init();

		$template = &$this->private->templates["parallax"];

		if (($block["layout_parallax_height"] == 0) || ($block["layout_parallax_height"] == "auto")) {
			$class .= " " . $template->blockReplace("Autoresize");
			$block["layout_parallax_height"] = "auto!important";
		} else {
			$block["layout_parallax_height"]  .= "px";
		}
		
		if ($block["layout_parallax_mode"] == "static") {
			$class .= " " . $template->blockReplace("Static");
		}
		
		if ($block["layout_parallax_overlay"]) {
			$block["overlay"] = $this->plugins["skineditor"]->Overlay($block["layout_parallax_overlay"]);
		} else {
			$block["overlay"] = "";
		}

		if ($block["layout_parallax_mode"] == "static") {
			$block["layout_parallax_height_real"] = "100%";
		} else {
			$block["layout_parallax_height_real"] = $block["layout_parallax_height_real"] . "px";
		}

		switch ($block["layout_parallax_resource"]) {
			//image
			case "1":
				return $template->blockReplace(
					"Main" , 
					array(
						"content"	=> $template->blockReplace(
							"Image" , 
							array(
								"content"	=> $block["layout_parallax_widgets"] ? $content : "",

							)
						),
						"class"	=> $class,

					),
					$block
				);
			break;

			//video
			case "2":
				return $template->blockReplace(
					"Main" , 
					array(
						"content"	=> $template->blockReplace(
							"Video" , 
							array(
								"content"	=> $block["layout_parallax_widgets"] ? $content : "",
							)
						),
						"class"	=> $class,
					),
					$block
				);
			break;

			//html
			case "3":
				return $template->blockReplace(
					"Main" , 
					array(
						"content"	=> $template->blockReplace(
							"Html" , 
							array(
								"content"	=> $block["layout_parallax_widgets"] ? $content : "",
							)
						),
						"class"	=> $class,

					),
					$block
				);
			break;

			default:
				return $content;
			break;
		}		
		
	}
	

	function hex2rgb($hex) {
	   $hex = str_replace("#", "", $hex);

	   if(strlen($hex) == 3) {
		  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
		  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
		  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
		  $r = hexdec(substr($hex,0,2));
		  $g = hexdec(substr($hex,2,2));
		  $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array("r"	=> $r, "g"	=> $g, "b"	=> $b);
	   //return implode(",", $rgb); // returns the rgb values separated by commas

	   return $rgb; // returns an array with the rgb values
	}	
}

?>