<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTopIntro extends CPlugin{
	
	var $tplvars; 

	function CTopIntro() {
		//$this->CPlugin($db, $tables , $templates);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetTopIntro($mod_id , $system = false , $widget = false) {
		global $_CONF , $_LANG_ID;


		if ($system) {
			$intro = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:topintro']} as c, {$this->tables['plugin:topintro_lang']} as l  WHERE c.item_id=l.item_id AND lang_id={$_LANG_ID} AND find_in_set({$mod_id} , item_modules_global) ORDER BY rand() limit 1"
			);
		} else {
			
			$intro = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:topintro']} as c, {$this->tables['plugin:topintro_lang']} as l  WHERE c.item_id=l.item_id AND lang_id={$_LANG_ID} AND find_in_set({$mod_id} , item_modules) AND item_status=1 ORDER BY rand() limit 1"
			);
		}

		//load the default if exits
		if (!is_array($intro)) {

			$intro = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:topintro']} as c, {$this->tables['plugin:topintro_lang']} as l  WHERE c.item_id=l.item_id AND lang_id={$_LANG_ID} AND item_default=1 AND item_status=1 ORDER BY rand() limit 1"
			);

		}
		

		if (is_array($intro)) {

			$tpl = new CTemplateDynamic($this->tpl_path . "intro.htm");
			$intro["item_overlay"] = $this->plugins["skineditor"]->Overlay($intro["item_overlay"]);

			$intro["title"] = $intro["item_title"] && $intro["item_show_title"] ? $tpl->blockREplacE("Title" , $intro) : "";
			$intro["text_1"] = $intro["item_text_1"] ? 
					$tpl->blockREplacE(
						"Text_1" , 
						array(
							"item_text_1"	=> nl2br($intro["item_text_1"])
						)
					): "";

			$intro["text_2"] = $intro["item_text_2"] ? 
					$tpl->blockREplacE(
						"Text_2" , 
						array(
							"item_text_2"	=> nl2br($intro["item_text_2"])
						)
					): "";



			switch ($intro["item_link_type"]) {
				case "0":
					$more = "";
				break;

				case "1":
					$more = $intro["item_link_link"];
				break;

				case "2":
					if (is_array($this->plugins["modules"]->modules[$intro["item_link_module"]])) {
						$more = $this->plugins["modules"]->modules[$intro["item_link_module"]]["link"];
					}						
				break;
			}

			if ($intro["item_link_type"]) {
				$intro["link"] = $more;
				$intro["button"] = $tpl->blockReplace("Button" , $intro);
			} else {
				$intro["button"] = "";
			}

			return $tpl->blockReplace(
				$intro["item_type"] == "1" ? "Image" : "Video" , 
				$intro
			);

		}
		
	}
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {

		if ($module["mod_id"]) {
			$bg  = 	$this->GetTopIntro($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$bg  = 	$this->GetTopIntro($module["module_id"] , true);
		}
		

		global $_TSM;

		$_TSM["PUB:TOPINTRO"] = $bg;

		return $bg;
	}


}

?>