<?php

//compatibility with old version 
if (!defined("E_DEPRECATED")) {
	define("E_USER_DEPRECATED" , 8192 );
}

if (!defined("E_USER_DEPRECATED")) {
	define("E_USER_DEPRECATED" , 16384 );
}

define("ERROR_EMAIL" , "support@stempora.com");



/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.oxylus.ro
		mail: support@oxylus.ro		

	$Id: name.php,v 0.0.1 dd/mm/yyyy hh:mm:ss oxylus Exp $
	description
*/

error_reporting(0);


$supported_errors = array(
	10101	=> array(
		"title"		=> "Database Connection",
		"message"	=> "Invalid database selected !",
		"fix"		=> "<li>Please make sure you put the correct database name. Check upload/conf/database.php `\$_CONF[default]`. </li>
						<li>Make sure you gave to mysql user to access this database.</li>"
	),

	//parse error
	4	=> array(
		"title"		=> "Parse Error",
		"message"	=> "",
		"fix"		=> "<li>Please compare the file that gives error with the one from original package. Most likely there was a timeout during upload and only a part of the file was saved on the server.</li>
						<li>If you changed the file yourself then you have an error in code . </li>"
	),

);


function StembaseShutDown_template($error) {
	global $supported_errors;

	if (isset($_SERVER["HTTPS"]) && (strtoupper($_SERVER["HTTPS"]) == "ON")) {
		$_TSM["PRIV.BASE.HREF"] = 	"https://" . dirname( $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"] ) . "/";
	} else {
		$_TSM["PRIV.BASE.HREF"] = 	"http://" . dirname( $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"] ) . "/";
	}


	$type = array(
		1		=>  "Fatal Error",
		2		=>  "Warning",
		4		=>	"Parse",
		8		=>	"Notice",
		8192	=>	"Deprecated",
		-1		=>	"System Error",
	);

	if (!$type[$error["type"]]) {

		$error["type"] = -1;
	}

	//treat parse errors


	switch ($error["type"]) {
		case 4:
			$error_msg = array(
					"title"		=> $supported_errors[$error["type"]]["title"],
					"message"	=> $error["message"],
					"fix"		=> $supported_errors[$error["type"]]["fix"],
					"code"		=> $key,
					
					"file"		=> $error["file"],
					"line"		=> $error["line"],
			);		
		break;

		default:
			if ($supported_errors[$error["message"]]) {

				$error_msg = array(
						"title"		=> $supported_errors[$error["message"]]["title"],
						"message"	=> $supported_errors[$error["message"]]["message"],
						"fix"		=> $supported_errors[$error["message"]]["fix"],
						"code"		=> $key,
						
						"file"		=> $error["file"],
						"line"		=> $error["line"],
				);
			} else {

				$error_msg = array(
						"title"		=> $type[$error["type"]],
						"message"	=> $error["message"],
					
						"file"		=> $error["file"],
						"line"		=> $error["line"],
				);

			}
		break;
	}

	if (constant("ERROR_EMAIL") !="") {

		@mail(
			ERROR_EMAIL,
			"System Error: " . $_SERVER["HTTP_HOST"],
			"
				<table border='0' cellspacing='1'>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Type:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>" . $type[$error["type"]] . "</td>
					</tr>
					<tr>
						<td  style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Message:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$error['message']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>File:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$error['file']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Line:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$error['line']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Server:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$_SERVER['HTTP_HOST']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Link:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Referer:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$_SERVER['HTTP_REFERER']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Client IP:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>{$_SERVER['REMOTE_ADDR']}</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>Date:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'>" . date("+r") . "</td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>\$_GET:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'><pre>" . print_r($_GET,true) . "</pre></td>
					</tr>
					<tr>
						<td style='background: #00aeef;padding:4px 10px;font-size: 12px;color: #fff; text-align: right; font-weight: bold; '>\$_SESSION:</td>
						<td style='background: #efefef;padding:4px;font-size: 12px;'><pre>" . print_r($_SESSION,true) . "</pre></td>
					</tr>
					<tr>
						<td colspan='2' style='text-align: right;background: #efefef;padding:4px;font-size: 12px;'>powered by <a href='http://www.stempora.com'>Stempora Framework</a></td>
				</table>
			",
			"Content-type: text/html\r\n" . 
			"From: notice@stempora.com\r\n".
			"X-Mailer: PHP/" . phpversion()
		);
		
	}
	
	
	

	
return '<!DOCTYPE html>
<html>
	<head>

		<title>Stembase Error...</title>
		<base href="' . $_TSM['PRIV.BASE.HREF'] . '" />
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<link href="' . _LIBPATH . 'error/assets/css/style.css" rel="stylesheet" media="screen">
	    <script src="' . _LIBPATH . 'error/assets/js/jquery.min.js"></script>
	    <script src="' . _LIBPATH . 'error/assets/js/custom.js"></script>

	</head>

	<body>
		<div class="content">
			<h1>We are sorry!</h1>
			<h2>THERE SEEMS TO BE AN ERROR</h2>


			<div class="error">
				<h2>Error details :</h2>
				<div class="holder">
				<table cellspacing="0" cellpadding="0">	
					<tr>
						<td class="title">' . $error_msg["title"] . ':</td>
						<td class="value">' . strip_tags($error_msg["message"]) . '</td>
					</tr>

					<tr>
						<td class="title">File: </td>
						<td class="value">' . $error_msg["file"] . '</td>
					</tr>

					<tr>
						<td class="title">Line: </td>
						<td class="value">' . $error_msg["line"] . '</td>
					</tr>
				</table>

					<div class="note">
						<p>This error notification was already sent automatically to our support staff. We apologize for any inconvenience this may have caused!</p>

						<p>We are working on it, please allow 24h to pass before refreshing. If this error persists, contact <a href="mailto:support@stempora.com">support@stempora.com</a>.</p>
					</div>
				</div>				
			</div>

			<div class="powered">
				Powered by <a href="http://www.stempora.com" class="stempora">www.stempora.com</a>
			</div>
		</div>
	</body>
</html>';
}

function StembaseShutDown(){

	global $StembaseShutDown_template;
	
    $error=error_get_last();

    if($error==null) {
        
    } else {

		switch ($error["type"]) {

			case E_USER_ERROR:
			case E_USER_WARNING:

			case E_COMPILE_ERROR:
			//E_COMPILE_WARNING
			case E_CORE_ERROR:
			//E_CORE_WARNING

			case E_ERROR:
//			case E_WARNING:
			case E_PARSE:

//			case E_RECOVERABLE_ERROR:

				if (php_sapi_name() == "cli") {
				} else {			
					ob_clean();
					header('HTTP/1.1 503 Service Temporarily Unavailable' , true);
					header('Status: 503 Service Temporarily Unavailable');
					header('Retry-After: 3600');
				}



				echo StembaseShutDown_template(
					$error
				);

				die();
			break;
			
			case E_NOTICE:
			case E_STRICT:
			case E_USER_NOTICE:
			case E_DEPRECATED:
			case E_USER_DEPRECATED:
				//ignore this type of errors
			break;

		}


	}
   
}

function StembaseErrorsHandlerDisable() {
	set_error_handler('StembaseShutDownHandlerEmpty');
}

function StembaseErrorsHandlerRestore() {
	restore_error_handler();
}

function StembaseExceptionHandler($exception) {

	StembaseShutDownHandler(
		E_ERROR, 
		$exception->getMessage(), 
		$exception->getFile(), 
		$exception->getLine()
	);
}


function StembaseShutDownHandlerEmpty($errno, $errstr, $errfile, $errline){} 
function StembaseShutDownHandler($errno, $errstr, $errfile, $errline) {

    switch ($errno) {
	    case E_USER_ERROR:
	    case E_USER_WARNING:

		case E_ERROR:
		//case E_WARNING:
		case E_PARSE:

		case E_CORE_WARNING:
		case E_CORE_ERROR:

		case E_COMPILE_ERROR:
		case E_COMPILE_WARNING:
		case E_RECOVERABLE_ERROR:

			if (php_sapi_name() == "cli") {
			} else {			

				//clearn headers if anythign sent already
				if (ob_get_contents()) {
					ob_clean();
				}
				
				header('HTTP/1.1 503 Service Temporarily Unavailable' , true);
				header('Status: 503 Service Temporarily Unavailable');
				header('Retry-After: 3600');
			}



			echo StembaseShutDown_Template(
				array(
					"type"		=>	$errno , 
					"message"	=>	$errstr , 
					"file"		=>	$errfile,
					"line"		=>	$errline
				)
			);

			die();
		break;
		
	    case E_STRICT:
	    case E_USER_NOTICE:
		case E_DEPRECATED:
		case E_USER_DEPRECATED:
		break;

	}

}


/**
* description
*
* @param
*
* @return
*
* @access
*/

//register php crash error
if (function_exists("register_shutdown_function")) {
	register_shutdown_function('StembaseShutDown');
}

set_error_handler("StembaseShutDownHandler" , E_ALL);
set_exception_handler('StembaseExceptionHandler');

//set_error_handler(array(' ErrorHandler ', 'errorHandler'));
//set_exception_handler(array(' ErrorHandler ', 'exceptionHandler'));



//register warnings and the rest noncrashing errors
//
//set_exception_handler("StembaseShutDown");


//throw new Exception('Uncaught Exception');


?>