<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CWidgetsWidgetLinksWIcons extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "17",
		"name"	=> "Links w/ Icons",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		if (!is_array($widget)) {
			return "";
		}

		$links = $this->module->GetStaticItems($widget);
		
		if (!is_array($links)) {
			return "";
		}
	
		
		global $base;
	
		foreach ($links as $key => $val) {

			$more = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"]
			));

			$links[$key]["link"] = $more;
			$links[$key]["icon"] = $this->tpl->blockReplace($val["item_link_icon"] ? "Icon" : "NoIcon", $val);


			if ($val["item_link_type"]) {
				$links[$key]["content"] = $this->tpl->blockExists("Link") ? $this->tpl->blockReplace("Link" , $links[$key]) : "";
			} else {
				$links[$key]["content"] = $this->tpl->blockExists("NoLink") ?  $this->tpl->blockReplace("NoLink" , $links[$key]) : "";
			}
						
			
		}

		
		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$this->tpl, 
					"",	
					$links
				)
			),
			$widget ,
			array(
				"selected"	=> ""
			)
		);

	}

}


?>