/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBModuleCTA = Object.create(STBModule.prototype);

STBModuleCTA.name = "ModuleCTA";
STBModuleCTA.initPaddings = function () {

	var cta = $('.widget-cta:not(.__done)').find('.cta-btn');

	if (cta.length > 0) {
		cta.each(function () {

			var buttonWidth = $(this).outerWidth();

			if ($("html").attr("dir") == "rtl") {
				$(this).siblings().css('padding-left', buttonWidth + 20);
			} else {
				$(this).siblings().css('padding-right', buttonWidth + 20);
			}

			$(this).addClass("__done");
		});
	}
}

STBModuleCTA.resetPaddings = function() {
	$('.widget-cta').removeClass("__done");
}

STBModuleCTA.runOnReady = function() {
	STBModuleCTA.initPaddings();
}

STBModuleCTA.runOnContentUpdate = function() {
	STBModuleCTA.initPaddings();
}

STBModuleCTA.runOnResize = function() {
	STBModuleCTA.resetPaddings();
	STBModuleCTA.initPaddings();
}

site.registerModule(STBModuleCTA);