<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CServicesWidgetMenu extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "3",
		"name"	=> "Side Menu",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:services_cats']} as i,
				{$this->tables['plugin:services_cats_lang']} as il
			WHERE 				
				i.cat_id = il.cat_id AND 
				il.lang_id={$widget[lang_id]} AND 
				i.module_id={$widget[widget_module]} AND 
				cat_status = 1 AND 
				cat_link_type > 0 

			ORDER BY  cat_order ASC" 
		);

		
		if (!is_array($items)) {
			return "";
		}

				
		if (is_array($items)) {	

			foreach ($items as $key => $val) {
				$link = "";

				switch ($val["cat_link_type"]) {

					case "1":
					case "2":
					case "3":

						$link = $this->module->plugins["modules"]->BuildLink(array(
							"type"	=> $val["cat_link_type"],
							"link"	=> $val["cat_link_link"],
							"module"=> $val["cat_link_module"],
							"global"=> $val["cat_link_global"]
						));
					break;

					case "4":
						$link = $widget["link"] . $val["cat_url"] . "/";
					break;
				}

				$items[$key]["link"] = $link;
				$items[$key]["icon"] = $this->tpl->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);
				$items[$key]["selected"] = ($val["cat_url"] == $_GET["cat_url"]) && ($_GET["module_id"] == $val["module_id"]) ? $this->tpl->blockReplace("selected") : "";
			}			
		}

		
		return $this->tpl->blockReplace(
			"Main",
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),
				"widget_style"	=> $this->tpl->blockReplace($widget["settings"]["set_style"] == "2" ? "widget-impact" : "widget-standard"),
			),
			$widget,
			$widget["settings"],
			$widget["mod_settings"]
		);

	}
	
}


?>